Option Strict On
Option Explicit On
Imports System.Runtime.InteropServices

Module KeyChkSCB

    ' KeyChk Secure-Communication Block (SCB).
    '   This memory block is used to pass information to/from the KeyChk DLL.
    ' -------------------------------------------------------------------------
    ' Please see the manual for a detailed description of each field.
    ' -------------------------------------------------------------------------
    ' The SCB used by the KeyChk DLL is a single 512-Byte Structure.
    '   The reason that the SCB_UTF16 structure must be embedded as a field
    '     of the SCB structure is that Visual Basic does not allow
    '       ANSI and UTF-16 fields within the same structure.

    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure SCB
        Dim Err_Code As Short           ' Main Error Code.
        Dim Err_Status1 As Short        ' Error Status 1.
        Dim Err_Status2 As Short        ' Error Status 2.
        Dim Func_Code As Byte           ' KeyChk Function Code.
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=5)> _
        Public SCB_ID As String         ' SCB ID s/b "Kc.6".
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=9)> _
        Public Prod_ID As String        ' Product-ID (Unicode UTF-8).
        Dim Reserved1 As Byte           ' Reserved.
        Dim Feature_Flags As UInt16     ' Least Significant Bit = Flag 1, Most Significant Bit = Flag 16.
        Dim Prod_Serial As UInt32       ' Product Serial Number.
        Dim Prod_PIN As UInt32          ' Product ID Number (PIN).
        Dim Uses_Limit As Int16         ' Uses Limit (Runs Left).  -1 means Unlimited, 0 means Expired.
        Dim Time_Limit As UInt16        ' Time Limit (Days Left).  &HFFFF means Unlimited, 0 means Expired or on Last Day.
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=9)> _
        Public ED_ASCII As String       ' Expire-Date MM/DD/YYYY (ASCIIZ).
        Dim User_Data_01 As Byte        ' User-Data.
        Dim User_Data_02 As Byte
        Dim User_Data_03 As Byte
        Dim User_Data_04 As Byte
        Dim User_Data_05 As Byte
        Dim User_Data_06 As Byte
        Dim User_Data_07 As Byte
        Dim User_Data_08 As Byte
        Dim User_Data_09 As Byte
        Dim User_Data_10 As Byte
        Dim User_Data_11 As Byte
        Dim User_Data_12 As Byte
        Dim User_Data_13 As Byte
        Dim User_Data_14 As Byte
        Dim User_Data_15 As Byte
        Dim User_Data_16 As Byte
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=6)> _
        Public Reserved2 As String      ' Reserved.
        Dim Lasered_ID_1 As Byte        ' Key Lasered-ID (LID).
        Dim Lasered_ID_2 As Byte
        Dim Lasered_ID_3 As Byte
        Dim Lasered_ID_4 As Byte
        Dim Lasered_ID_5 As Byte
        Dim Lasered_ID_6 As Byte
        Dim Lasered_ID_7 As Byte
        Dim Lasered_ID_8 As Byte
        Dim Renew_Used_Count As Byte    ' Renew Used-Count.
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> _
        Public Reserved3 As String      ' Reserved.
        Dim scb_utf16 As SCB_UTF16      ' Define the part of the SCB with UTF16 fields.
    End Structure
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Unicode)> _
    Public Structure SCB_UTF16
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> _
        Public Reg_Name As String       ' Registration Name (UTF-16 Unicode).
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> _
        Public Reg_Company As String    ' Registration Compnay (UTF-16 Unicode).
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> _
        Public Reg_Other As String      ' Registration Other Info (UTF-16 Unicode).
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=16)> _
        Public Expire_Date As String    ' Expire-Date using Local Region settings (UTF-16 Unicode).
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=16)> _
        Public Expire_Time As String    ' Expire-Time using Local Region settings (UTF-16 Unicode).
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=88)> _
        Public Reserved4 As String  ' Reserved.

    End Structure

    ' Declare KeyChk DLL function.
#If PLATFORM = "x64" Then
    Declare Sub KeyChk Lib "KeyChk64.dll" (ByRef KeyChkSCB As SCB)
#Else
    Declare Sub KeyChk Lib "KeyChk.dll" (ByRef KeyChkSCB As SCB)
#End If

End Module
